<?php
namespace boru\dweb\Middleware;

use boru\dweb\Contracts\MiddlewareInterface;
use boru\dweb\Http\Request;
use boru\dweb\Session\PhpSession;
use boru\dweb\Contracts\SessionInterface;

/**
 * Boots native PHP session and exposes it as SessionInterface on the Request.
 *
 * - Starts session (if not already started)
 * - Attaches a PhpSession instance via Request::withMeta('dweb.session', ...)
 */
class SessionMiddleware implements MiddlewareInterface
{
    /**
     * @param Request $request
     * @param callable $next
     * @return mixed
     */
    public function handle($request, $next)
    {
        // Start session if needed
        if (function_exists('session_status') && session_status() === PHP_SESSION_NONE) {
            // Suppress headers-already-sent noise; framework users are expected to call early.
            @session_start();
        } elseif (!function_exists('session_status') && !isset($_SESSION)) {
            // Very old PHP fallback, though your min is 5.6 so this is mostly redundant.
            @session_start();
        }

        // Wrap in SessionInterface
        $session = new PhpSession();

        // Attach to Request meta
        $request = $request->withMeta('dweb.session', $session);

        return $next($request);
    }
}
