<?php
namespace boru\dweb\Modules\Core;

use boru\dweb\Config\ConfigKeys;
use boru\dweb\Contracts\LayoutRegistryInterface;
use boru\dweb\Contracts\ModuleInterface;
use boru\dweb\Contracts\SettingsInterface;
use boru\dweb\Contracts\TemplateLocatorInterface;
use boru\dweb\Kernel\Container;
use boru\dweb\Smoke\SmokeSuiteProviderInterface;
use boru\dweb\Smoke\SmokeSuiteRegistry;

/**
 * Core framework module.
 *
 * Intentionally does not define app endpoints.
 * Modules provide Views/Actions.
 */
class CoreModule implements ModuleInterface, SmokeSuiteProviderInterface
{
    public function getName()
    {
        return 'core';
    }

    public function register(Container $container, SettingsInterface $settings)
    {
        // Register module template directory with the locator
        $locator = $container->get(TemplateLocatorInterface::class);
        $locator->registerModule($this->getName(), __DIR__ . DIRECTORY_SEPARATOR . 'templates');

        // Register core layout(s) with central registry if present
        if ($container->has(LayoutRegistryInterface::class)) {
            /** @var LayoutRegistryInterface $layouts */
            $layouts = $container->get(LayoutRegistryInterface::class);

            // Canonical Core default layout: "Core:default" → core/layouts/default
            $layouts->register('core:default', $this->getName(), 'layouts/default');
            $layouts->register('Core:default', $this->getName(), 'layouts/default');

            // Determine effective default layout name (host app may override)
            $defaultName = (string)$settings->get(
                ConfigKeys::DEFAULT_LAYOUT,
                'core:default'
            );
            $layouts->setDefaultName($defaultName);

            // Optional convenience alias: "default" → current core default template
            if (!$layouts->get('default')) {
                $layouts->register('default', $this->getName(), 'layouts/default');
            }
        }
    }

    public function routes($routes, Container $container, SettingsInterface $settings)
    {
        $routes->addModuleAction('socketToken', $container, array('GET'));
        $routes->addModuleView('socketConfigTest', $container, array('GET'));
    }

    public function suites(SmokeSuiteRegistry $registry)
    {
        $registry->add(new \boru\dweb\Modules\Core\Smoke\CoreSmokeSuite());
    }
}
