<?php
namespace boru\dweb\Modules\Core\Smoke;

use boru\dweb\Smoke\SmokeTestInterface;
use boru\dweb\Smoke\SmokeContext;
use boru\dweb\Smoke\RequestFactory;
use boru\dweb\Smoke\Assert;

class SocketConfigTestViewTest implements SmokeTestInterface
{
    public function name() { return 'GET /core/socketConfigTest renders HTML'; }

    public function run(SmokeContext $ctx)
    {
        $req = RequestFactory::make('/core/socketConfigTest', 'GET');
        $resp = $ctx->dispatch($req);

        Assert::equals(200, $resp->status(), 'Expected 200');
        $body = $resp->body();

        Assert::contains('DWEB_SOCKET_CONFIG', $body, 'Expected DWEB_SOCKET_CONFIG content in HTML');
    }
}
