<?php
namespace boru\dweb\Modules\Realtime\Actions;

use boru\dweb\Mvc\AbstractAction;
use boru\dweb\Http\Request;

/**
 * Demo action that publishes messages via SocketPublisher.
 *
 * URL:
 *   ?action=Realtime.publishDemo&userId=demo-user
 *
 * Behavior:
 *   - Broadcasts a "realtimeDemo" event to all connected clients.
 *   - If userId is provided, also sends a "notification" to room "user:{userId}".
 */
class PublishDemoAction extends AbstractAction
{
    public function handle(Request $req)
    {
        $ctx = $this->ctx();
        $publisher = $ctx->socketPublisher();

        if (!$publisher) {
            return $this->error(
                'SocketPublisher service not available. Ensure realtime is configured and enabled.',
                500
            );
        }

        $userId = $req->param('userId', null);
        if ($userId === null) {
            // Allow POST body as well:
            $body = $req->json();
            if (is_array($body) && isset($body['userId'])) {
                $userId = $body['userId'];
            }
        }
        if ($userId !== null) {
            $userId = (string)$userId;
        }

        // 1) Broadcast demo event
        $okBroadcast = $publisher->publish(
            null, // null channel => broadcast
            'realtimeDemo',
            array(
                'message' => 'Hello from Realtime.publishDemo (broadcast)',
                'at'      => date('c'),
            )
        );

        // 2) Optional per-user notification
        $okUser = true;
        if ($userId !== null && $userId !== '') {
            $okUser = $publisher->publish(
                'user:' . $userId,
                'notification',
                array(
                    'message' => 'Hello ' . $userId . ', this is a targeted message from publishDemo.',
                    'at'      => date('c'),
                )
            );
        }

        return $this->success(array(
            'broadcast_sent'   => (bool)$okBroadcast,
            'user_notification'=> (bool)$okUser,
            'userId'           => $userId,
        ));
    }
}
