<?php
namespace boru\dweb\Modules\Realtime;

use boru\dweb\Cli\CliCommandProviderInterface;
use boru\dweb\Contracts\AssetProviderInterface;
use boru\dweb\Kernel\Container;
use boru\dweb\Contracts\ModuleInterface;
use boru\dweb\Contracts\SettingsInterface;
use boru\dweb\Contracts\TemplateLocatorInterface;
use boru\dweb\Routing\ModuleRouteCollection;

/**
 * Realtime demo module.
 *
 * Routes:
 *   View   Realtime.socketDemo   => /Realtime/socketDemo
 *   Action Realtime.socketToken  => ?action=Realtime.socketToken (or /api/Realtime/socketToken)
 */
class RealtimeModule implements ModuleInterface, AssetProviderInterface, CliCommandProviderInterface
{
    public function getAssetPath()
    {
        // No assets yet, but keep pattern consistent
        return __DIR__ . DIRECTORY_SEPARATOR . 'assets';
    }

    public function getName()
    {
        return 'Realtime';
    }

    public function register(Container $container, SettingsInterface $settings)
    {
        // Register module template directory with the locator
        $locator = $container->get(TemplateLocatorInterface::class);
        $locator->registerModule($this->getName(), __DIR__ . DIRECTORY_SEPARATOR . 'templates');
    }

    public function routes(ModuleRouteCollection $routes, Container $container, SettingsInterface $settings)
    {
        // View: demo page with socket.io client
        $routes->addModuleView('socketDemo', $container);

        // Action: returns a socket auth token for the current (or demo) user
        $routes->addModuleAction('socketToken', $container, array('GET'));

        // Action: demo publisher (fires broadcast + optional per-user event)
        $routes->addModuleAction('publishDemo', $container, array('POST', 'GET'));
    }

    public function commands(\boru\dweb\Cli\CommandRegistry $registry)
    {
        // No module-specific CLI commands for now
    }
}
