{* src/Modules/Realtime/templates/realtime/socket_demo.tpl *}

<h1>{$title|escape}</h1>

<p>
    This is a minimal Socket.IO demo using the dweb socket server.
</p>

<ol>
    <li>Ensure your env config has:
        <pre>SOCKET_ENABLED=true
SOCKET_AUTH_MODE=jwt
SOCKET_JWT_SECRET=...</pre>
    </li>
    <li>Start the server:
        <pre>vendor/bin/dweb socket:serve --env-bootstrap=/abs/path/to/env.php --port=3001</pre>
    </li>
    <li>Then use this page to request a token and connect.</li>
</ol>

<hr />

<div>
    <button id="btnConnect">2) Connect</button>
    <button id="btnPing" disabled>3) Send Ping</button>
</div>

<pre id="log" style="margin-top: 16px; padding: 8px; background: #f5f5f5; max-height: 300px; overflow-y: auto; font-size: 12px;"></pre>

<script src="https://cdn.socket.io/4.7.2/socket.io.min.js" crossorigin="anonymous"></script>

<script>
(function () {
    var logEl = document.getElementById('log');
    var btnConnect = document.getElementById('btnConnect');
    var btnPing = document.getElementById('btnPing');

    var token = null;
    var socket = null;

    function log(msg, data) {
        var line = '[' + new Date().toISOString() + '] ' + msg;
        if (typeof data !== 'undefined') {
            try {
                line += ' ' + JSON.stringify(data);
            } catch (e) {
                // ignore
            }
        }
        logEl.textContent += line + "\n";
        logEl.scrollTop = logEl.scrollHeight;
    }
    // 2) Connect
    btnConnect.addEventListener('click', function () {
        dweb.socket.on('connect', function() {
            log('Connected via dweb.socket. id=' + dweb.socket.id);
            btnPing.disabled = false;
            btnConnect.disabled = true;
        });
        dweb.socket.on('disconnect', function(reason) {
            log('Disconnected via dweb.socket: ' + reason);
            btnPing.disabled = true;
            btnConnect.disabled = false;
        });
        dweb.socket.on('realtimeDemo', function(payload) {
            log('realtimeDemo event via dweb.socket', payload);
        });
        dweb.socket.on('pong', function (payload) {
            log('Received pong', payload);
        });
        dweb.socket.on('notification', function (payload) {
            log('notification event via dweb.socket', payload);
        });
        dweb.socket.on('auth_error', function (payload) {
            log('auth_error via dweb.socket', payload);
        });
        dweb.socket.on('connect_error', function (err) {
            log('connect_error via dweb.socket', { message: err && err.message });
        });
        dweb.socket.ensureConnected(function(err, s) {
            if (err) {
                log('Error connecting via dweb.socket', { message: err.message });
                return;
            }
            socket = s;
            log('dweb.socket connectedzz', { id: socket.id });
        });
        
        return;
    });

    // 3) Ping
    btnPing.addEventListener('click', function () {
        /*if (!socket || !socket.connected) {
            log('Not connected yet.');
            return;
        }
        var payload = { foo: 'bar', at: new Date().toISOString() };
        log('Sending ping', payload);
        socket.emit('ping', payload);*/
        dweb.socket.emit('ping', { foo: 'bar', at: new Date().toISOString() });
    });

})();
</script>
