<?php
namespace boru\dweb\Modules\Skeleton\Actions;

use boru\dweb\Mvc\AbstractAction;
use boru\dweb\Http\JsonResponse;

class CliDetachAction extends AbstractAction
{
    public function handle($req)
    {
        $cli = $this->ctx()->cli();
        if (!$cli) {
            return new JsonResponse(array(
                'ok' => false,
                'error' => 'CliInvoker not available in ControllerContext'
            ), 500);
        }

        // Run a command that stays alive long enough to observe.
        $sec = 3;
        $options = array('detach' => true);
        //$options = [];
        $res = $cli->run('sleep', array("-e","clienv.php",(string)$sec), $options);

        return new JsonResponse(array(
            'ok' => $res->ok(),
            'pid' => $res->stdout,
            'stderr' => $res->stderr,
        ), $res->ok() ? 200 : 500);
    }
}
