<?php
namespace boru\dweb\Modules\Skeleton\Actions;

use boru\dweb\Mvc\AbstractAction;
use boru\dweb\Http\JsonResponse;

class CliHelpAction extends AbstractAction
{
    public function handle($req)
    {
        $cli = $this->cli();
        if (!$cli) {
            return new JsonResponse(array(
                'ok' => false,
                'error' => 'CliInvoker not available in ControllerContext'
            ), 500);
        }

        $res = $cli->run('help');

        return new JsonResponse(array(
            'ok' => $res->ok(),
            'exit' => $res->exitCode,
            'stdout' => $res->stdout,
            'stderr' => $res->stderr,
        ), $res->ok() ? 200 : 500);
    }
}
