<?php
namespace boru\dweb\Modules\Skeleton\Actions;

use boru\dweb\Mvc\AbstractAction;
use boru\dweb\Http\JsonResponse;

class ContextInfoAction extends AbstractAction
{
    public function handle($req)
    {
        $data = array(
            'module' => 'Skeleton',
            'urls' => array(
                'home' => $this->dweb()->view('home'),
                'ctxDemo' => $this->dweb()->view('contextDemo'),
            ),
            'debug' => (bool)$this->ctx()->settings()->get(\boru\dweb\Config\ConfigKeys::DEBUG_ENABLED, false),
            'hasCli' => $this->ctx()->cli() ? true : false,
            'hasLogger' => $this->ctx()->logger() ? true : false,
            'hasAssets' => $this->ctx()->assets() ? true : false,
        );

        return new JsonResponse($data);
    }
}
