<?php
namespace boru\dweb\Modules\Skeleton\Actions;

use boru\dweb\Mvc\AbstractAction;
use boru\dweb\Http\Request;
use boru\dweb\Http\SseResponse;

class SseStreamAction extends AbstractAction
{
    public function handle(Request $req)
    {
        // allow ?count= and ?ms= tuning for demo
        $count = (int)$req->query('count', 15);
        if ($count <= 0) $count = 15;

        $ms = (int)$req->query('ms', 700);
        if ($ms < 100) $ms = 100;

        $count=2;

        return SseResponse::stream(function ($send) use ($count, $ms) {

            $phrases = array(
                "🛰️  Incoming transmission...",
                "✅  Task complete.",
                "🔧  Tool call finished.",
                "🧠  Thinking… (server-side)",
                "📦  Packaging response chunk…",
                "🌀  Streaming continues…",
                "✨  Something random happened.",
                "📡  Still connected.",
                "🧱  Building UI from fragments.",
                "🕒  " . date('H:i:s'),
            );

            // Tell the UI we started
            $send($this->renderPartialToString('sse/_status', array(
                'status' => 'connected',
                'message' => 'SSE stream connected. Sending updates…',
            )), 'status');

            for ($i = 1; $i <= $count; $i++) {
                // pick a random phrase
                $msg = $phrases[array_rand($phrases)];

                // HTML fragment for "content" stream (append)
                $send($this->renderPartialToString('sse/_chunk', array(
                    'i' => $i,
                    'msg' => $msg,
                    'ts' => date('H:i:s'),
                )), 'content', (string)$i);

                usleep($ms * 1000);
            }

            // Tell the UI we finished
            $send($this->renderPartialToString('sse/_done', array(
                'status' => 'done',
                'message' => 'Stream finished (demo). Refresh page to reconnect.',
            )), 'status', 'final');
        });
    }
}
