<?php
namespace boru\dweb\Modules\Skeleton;

use boru\dweb\Cli\CliCommandProviderInterface;
use boru\dweb\Contracts\AssetProviderInterface;
use boru\dweb\Kernel\Container;
use boru\dweb\Contracts\ModuleInterface;
use boru\dweb\Contracts\SettingsInterface;
use boru\dweb\Contracts\TemplateLocatorInterface;
use boru\dweb\Routing\ModuleRouteCollection;
use boru\dweb\Smoke\SmokeSuiteProviderInterface;

class SkeletonModule implements ModuleInterface, AssetProviderInterface, SmokeSuiteProviderInterface, CliCommandProviderInterface
{
    public function getAssetPath()
    {
        return __DIR__ . DIRECTORY_SEPARATOR . 'assets';
    }
    public function getName()
    {
        return 'Skeleton';
    }

    public function register(Container $container, SettingsInterface $settings)
    {
        // Register module template directory with the locator
        $locator = $container->get(TemplateLocatorInterface::class);
        $locator->registerModule($this->getName(), __DIR__ . DIRECTORY_SEPARATOR . 'templates');
    }

    public function routes(ModuleRouteCollection $routes, Container $container, SettingsInterface $settings)
    {
        $routes->addModuleView('home', $container);
        $routes->addModuleView('another', $container);
        $routes->addModuleView('helloFragment', $container);
        $routes->addModuleView('helloFragmentHx', $container);
        $routes->addModuleView('sidebarFragment', $container);

        $routes->addModuleView('forwardToHome', $container);

        $routes->addModuleAction('ping', $container, array('GET'));
        $routes->addModuleAction('echo', $container, array('POST'));
        $routes->addModuleAction('deleteThing', $container, array('DELETE'));

        //SSE Demo
        $routes->addModuleView('sse', $container);
        $routes->addModuleAction('sseStream', $container, array('GET'));

        //Context Demos
        $routes->addModuleView('contextDemo', $container);
        $routes->addModuleAction('contextInfo', $container, array('GET'));

        //Smoke Test Action
        $routes->addModuleAction('cliHelp', $container, array('GET'));
        $routes->addModuleAction('cliDetach', $container, array('GET'));

        $routes->addModuleAction('pathParam', $container, array('GET', 'POST'), ['id', 'sub']);
    }

    public function suites(\boru\dweb\Smoke\SmokeSuiteRegistry $registry)
    {
        $registry->add(new \boru\dweb\Modules\Skeleton\Smoke\SkeletonSuite());
    }

    public function commands(\boru\dweb\Cli\CommandRegistry $registry)
    {
        // $registry->add(new \boru\dweb\Modules\Skeleton\Cli\SomeCommand());
    }
}
