<?php
namespace boru\dweb\Modules\Skeleton\Smoke;

use boru\dweb\Smoke\SmokeTestInterface;
use boru\dweb\Smoke\SmokeContext;
use boru\dweb\Smoke\RequestFactory;
use boru\dweb\Smoke\Assert;

class CliHelpActionTest implements SmokeTestInterface
{
    public function name() { return 'GET /api/Skeleton/cliHelp returns JSON'; }

    public function run(SmokeContext $ctx)
    {
        $req = RequestFactory::make('/api/Skeleton/cliHelp', 'GET');
        $resp = $ctx->dispatch($req);

        Assert::equals(200, $resp->status(), 'Expected 200');
        $body = $resp->body();

        Assert::contains('CLI commands', $body, 'Expected CLI commands in response');
    }
}
