<?php
namespace boru\dweb\Modules\Skeleton\Views;

use boru\dweb\Mvc\AbstractView;
use boru\dweb\Http\HtmlResponse;

class ContextDemoView extends AbstractView
{
    public function handle($req)
    {
        // Use ctx helpers (proof)
        $urls = array(
            'home'      => $this->dweb()->view('home'),
            'ctx demo'  => $this->dweb()->view('contextDemo'),
            'ctx json'  => $this->dweb()->action('contextInfo'),
        );

        $debug = (bool)$this->ctx()->settings()->get(\boru\dweb\Config\ConfigKeys::DEBUG_ENABLED, false);

        if ($this->ctx()->logger()) {
            $this->ctx()->logger()->info('Skeleton ContextDemoView loaded', array(
                'debug' => $debug,
            ));
        }

        return $this->layout(
            'layouts/default',
            'context/demo',
            array(
                'title' => 'ControllerContext Demo',
                'urls'  => $urls,
                'debug' => $debug,
                'hasCli' => $this->ctx()->cli() ? true : false,
                'hasAssets' => $this->ctx()->assets() ? true : false,
            )
        );
    }
}
