<?php
namespace boru\dweb\Modules\Skeleton\Views;

use boru\dweb\Mvc\AbstractView;
use boru\dweb\Http\Request;

/**
 * Simple example view that always forwards to Skeleton.home.
 *
 * Route might be something like /Skeleton/forward-home
 * depending on how you register it in SkeletonModule::routes().
 */
class ForwardToHomeView extends AbstractView
{
    /**
     * Invoke as a controller.
     *
     * @param Request $req
     * @return \boru\dweb\Http\HtmlResponse
     */
    public function handle(Request $req)
    {
        // Option 1: same module, so pass null and the short view name.
        // This will internally call ctx()->dispatchView('Skeleton.home', $req)
        // because moduleName is 'Skeleton' here.
        return $this->gotoView(null, 'home');

        // Option 2 (equivalent, more explicit):
        // return $this->gotoView('Skeleton', 'home');
    }
}
