<div class="sse-status-inner sse-status-done">
  <b>Status:</b> {$message|escape}
</div>

<script>
(function(){
  var root = document.getElementById('sse-demo');
  var out  = document.getElementById('sse-static');
  if (!root || !out) return;

  // Clone the visible content (status + stream)
  var status = root.querySelector('.sse-status');
  var stream = root.querySelector('.sse-stream');

  var frag = document.createDocumentFragment();

  if (status) {
    var statusClone = status.cloneNode(true);
    // remove SSE attributes (not required, but keeps DOM clean)
    statusClone.removeAttribute('sse-swap');
    frag.appendChild(statusClone);
  }

  if (stream) {
    var streamClone = stream.cloneNode(true);
    streamClone.removeAttribute('sse-swap');
    frag.appendChild(streamClone);
  }

  // Render static copy
  out.innerHTML = '';
  out.appendChild(frag);

  // Remove SSE root entirely -> stops reconnect
  root.parentNode.removeChild(root);
})();
</script>
