<h1>{$title|escape}</h1>

<p>
  This page demonstrates <b>HTMX SSE</b> streaming HTML fragments from a dweb Action.
  The server emits random chunks in a sleep-loop.
</p>

<hr>

<div class="sse-wrapper">
  <div id="sse-demo"
       class="sse-demo"
       hx-ext="sse"
       sse-connect="{$dweb->action('sseStream')|escape}">

    <div class="sse-status" sse-swap="status"></div>

    <div class="sse-stream"
         id="sse-stream"
         sse-swap="content"
         hx-swap="beforeend">
      <div class="sse-hint">Waiting for stream…</div>
    </div>
  </div>

  <div id="sse-static"></div>
</div>

<hr>

<p class="sse-notes">
  Notes:
  <br>- <code>sse-connect</code> opens an EventSource.
  <br>- <code>sse-swap="content"</code> listens for <code>event: content</code>.
  <br>- We set <code>hx-swap="beforeend"</code> so each event appends.
</p>
