<?php
namespace boru\dweb\Mvc;

use boru\dweb\Routing\CanonicalUrl;

class DwebHelper
{
    /** @var CanonicalUrl */
    private $canonical;

    /** @var string */
    private $moduleName;

    public function __construct(CanonicalUrl $canonical, $moduleName)
    {
        $this->canonical  = $canonical;
        $this->moduleName = (string)$moduleName;
    }

    public function module()
    {
        return $this->moduleName;
    }

    public function view($viewName, $tail = null)
    {
        $qualified = $this->canonical->qualifyView($this->moduleName, (string)$viewName);
        return $this->canonical->view($qualified, $tail);
    }

    public function action($actionName, $tail = null)
    {
        $qualified = $this->canonical->qualifyAction($this->moduleName, (string)$actionName);
        return $this->canonical->action($qualified, $tail);
    }

    public function mView($moduleName, $viewName, $tail = null)
    {
        $qualified = $this->canonical->qualifyView((string)$moduleName, (string)$viewName);
        return $this->canonical->view($qualified, $tail);
    }

    public function mAction($moduleName, $actionName, $tail = null)
    {
        $qualified = $this->canonical->qualifyAction((string)$moduleName, (string)$actionName);
        return $this->canonical->action($qualified, $tail);
    }

    // keep the convention consistent with templates
    public function sectionId($sectionName)
    {
        return 'section-' . (string)$sectionName;
    }

    public function sectionSelector($sectionName)
    {
        return '#section-' . (string)$sectionName;
    }

    // In boru\dweb\Rendering\TemplateHelper (or wherever $dweb lives)

    /**
     * Emit a marker that tells dweb.js to stop HTMX SSE reconnect.
     *
     * @param string|null $freezeSelector e.g. "#sse-static" to copy status/stream into a static target
     * @param bool $removeRoot if true, removes the hx-ext="sse" root node to hard-stop reconnect
     * @return string HTML
     */
    public function sseDoneMarker($freezeSelector = null, $removeRoot = true)
    {
        $attrs = $this->sseDoneAttrs($freezeSelector, $removeRoot);
        return '<span ' . $attrs . '></span>';
    }

    /**
     * Marker attributes (for embedding into your own element).
     *
     * @param string|null $freezeSelector
     * @param bool $removeRoot
     * @return string
     */
    public function sseDoneAttrs($freezeSelector = null, $removeRoot = true)
    {
        $out = array();
        $out[] = 'data-dweb-sse-done="1"';

        if ($freezeSelector) {
            $out[] = 'data-dweb-sse-freeze="' . htmlspecialchars((string)$freezeSelector, ENT_QUOTES, 'UTF-8') . '"';
        }
        if ($removeRoot) {
            $out[] = 'data-dweb-sse-remove="1"';
        }

        return implode(' ', $out);
    }

    public function viewWithParams($name, array $params = array())
    {
        $url = $this->view($name);
        if (!$params) return $url;

        $qs = http_build_query($params);
        return (strpos($url, '?') !== false)
            ? $url . '&' . $qs
            : $url . '?' . $qs;
    }

    public function actionWithParams($name, array $params = array())
    {
        $url = $this->action($name);
        if (!$params) return $url;

        $qs = http_build_query($params);
        return (strpos($url, '?') !== false)
            ? $url . '&' . $qs
            : $url . '?' . $qs;
    }

}
