<?php
namespace boru\dweb\Mvc;

use boru\dweb\Contracts\ModuleInterface;

class ModuleNamespaceResolver
{
    /**
     * Returns base namespace for a module's classes.
     *
     * Example:
     *   \boru\dweb\Modules\Skeleton\SkeletonModule  => boru\dweb\Modules\Skeleton
     *   \somevendor\someproject\Modules\Billing\BillingModule => somevendor\someproject\Modules\Billing
     *
     * @param ModuleInterface $module
     * @return string
     */
    public function moduleBaseNamespace(ModuleInterface $module)
    {
        $fqcn = get_class($module);
        $pos = strrpos($fqcn, '\\');
        if ($pos === false) return $fqcn;
        return substr($fqcn, 0, $pos);
    }

    /**
     * Build a FQCN under the module base namespace.
     *
     * @param ModuleInterface $module
     * @param string $suffix e.g. "Views\HomeView"
     * @return string
     */
    public function qualify(ModuleInterface $module, $suffix)
    {
        $base = $this->moduleBaseNamespace($module);
        $suffix = ltrim((string)$suffix, '\\');
        return $base . '\\' . $suffix;
    }
}
