<?php
namespace boru\dweb\Rendering;

use boru\dweb\Contracts\LayoutResolverInterface;
use boru\dweb\Contracts\LayoutRegistryInterface;

class DefaultLayoutResolver implements LayoutResolverInterface
{
    /** @var LayoutRegistryInterface */
    private $registry;

    public function __construct(LayoutRegistryInterface $registry)
    {
        $this->registry = $registry;
    }

    /**
     * {@inheritdoc}
     */
    public function resolve($controllerModuleName, $layoutSelector)
    {
        $controllerModuleName = (string)$controllerModuleName;
        $layoutSelector       = (string)$layoutSelector;

        // 1) Explicit module-local layout: anything with "/"
        if (strpos($layoutSelector, '/') !== false) {
            return array(
                'module' => $controllerModuleName,
                'layout' => $layoutSelector,
            );
        }

        // 2) Namespaced layout: "Module:layoutName"
        if (strpos($layoutSelector, ':') !== false) {
            $info = $this->registry->get($layoutSelector);
            if ($info) {
                return array(
                    'module' => $info['module'],
                    'layout' => $info['layout'],
                );
            }

            // Fallback: unknown name, treat as module-local template id
            return array(
                'module' => $controllerModuleName,
                'layout' => $layoutSelector,
            );
        }

        // 3) Bare logical name: use defaultName indirection.
        // e.g. "default" -> (App:default or Core:default) -> (module, layoutId)
        $name = $this->registry->getDefaultName();
        if ($name === null || $name === '') {
            // If no default configured, interpret as module-local for safety.
            return array(
                'module' => $controllerModuleName,
                'layout' => $layoutSelector,
            );
        }

        $info = $this->registry->get($name);
        if ($info) {
            return array(
                'module' => $info['module'],
                'layout' => $info['layout'],
            );
        }

        // If the registry says "defaultName = X" but X isn't registered, again
        // fall back to module-local.
        return array(
            'module' => $controllerModuleName,
            'layout' => $layoutSelector,
        );
    }
}
