<?php
namespace boru\dweb\Rendering;

use boru\dweb\Contracts\LayoutRegistryInterface;

class LayoutRegistry implements LayoutRegistryInterface
{
    /** @var array<string,array{module:string,layout:string}> */
    private $layouts = array();

    /** @var string|null */
    private $defaultName = null;

    public function register($name, $moduleName, $layoutId)
    {
        $name       = (string)$name;
        $moduleName = (string)$moduleName;
        $layoutId   = (string)$layoutId;

        if ($name === '') return;

        $this->layouts[$name] = array(
            'module' => $moduleName,
            'layout' => $layoutId,
        );
    }

    public function get($name)
    {
        $name = (string)$name;
        if ($name === '') return null;

        if (!isset($this->layouts[$name])) {
            return null;
        }

        return $this->layouts[$name];
    }

    public function setDefaultName($name)
    {
        $name = (string)$name;
        $this->defaultName = $name !== '' ? $name : null;
    }

    public function getDefaultName()
    {
        return $this->defaultName;
    }

    public function all()
    {
        return $this->layouts;
    }
}
    