<?php
namespace boru\dweb\Rendering;

use boru\dweb\Contracts\SettingsInterface;
use boru\dweb\Contracts\TemplateLocatorInterface;

class TemplateLocator implements TemplateLocatorInterface
{
    /** @var SettingsInterface */
    private $settings;

    /** @var array<string,string> moduleName => templatesDir */
    private $moduleTemplateDirs = array();

    /**
     * @param SettingsInterface $settings
     */
    public function __construct(SettingsInterface $settings)
    {
        $this->settings = $settings;
    }

    public function registerModule($moduleName, $templatesDir)
    {
        $moduleName = (string)$moduleName;
        $templatesDir = rtrim((string)$templatesDir, DIRECTORY_SEPARATOR);
        $this->moduleTemplateDirs[$moduleName] = $templatesDir;
    }

    public function resolve($moduleName, $templateId, $extension)
    {
        $moduleName = (string)$moduleName;
        $templateId = ltrim((string)$templateId, '/\\');
        $extension  = ltrim((string)$extension, '.');

        // host override root (locked)
        // Recommended setting key:
        //   dweb.templates.path = /path/to/app/templates
        $appRoot = $this->settings->get('dweb.templates.path', null);
        if ($appRoot) {
            $appRoot = rtrim((string)$appRoot, DIRECTORY_SEPARATOR);
            $override = $appRoot
                . DIRECTORY_SEPARATOR . $moduleName
                . DIRECTORY_SEPARATOR . $templateId . '.' . $extension;

            if (is_file($override)) return $override;
        }

        // module default
        $moduleDir = isset($this->moduleTemplateDirs[$moduleName])
            ? $this->moduleTemplateDirs[$moduleName]
            : null;

        if ($moduleDir) {
            $candidate = $moduleDir
                . DIRECTORY_SEPARATOR . $templateId . '.' . $extension;
            if (is_file($candidate)) return $candidate;
        }
        throw new \RuntimeException("Template not found: {$moduleName}::{$templateId}.{$extension} -- {$candidate}");
        return null;
    }
}
