<?php
namespace boru\dweb\Session;

use boru\dweb\Contracts\SessionInterface;

class PhpSession implements SessionInterface
{
    public function get($key, $default = null)
    {
        if (!isset($_SESSION) || !is_array($_SESSION)) {
            return $default;
        }
        $k = (string)$key;
        return array_key_exists($k, $_SESSION) ? $_SESSION[$k] : $default;
    }

    public function set($key, $value)
    {
        if (!isset($_SESSION) || !is_array($_SESSION)) {
            $_SESSION = array();
        }
        $_SESSION[(string)$key] = $value;
    }

    public function remove($key)
    {
        if (!isset($_SESSION) || !is_array($_SESSION)) {
            return;
        }
        $k = (string)$key;
        if (array_key_exists($k, $_SESSION)) {
            unset($_SESSION[$k]);
        }
    }

    public function all()
    {
        if (!isset($_SESSION) || !is_array($_SESSION)) {
            return array();
        }
        return $_SESSION;
    }

    public function regenerateId($deleteOld = true)
    {
        if (function_exists('session_regenerate_id')) {
            // Suppress warnings if headers already sent; caller is responsible for “good” usage.
            @session_regenerate_id($deleteOld ? true : false);
        }
    }
}
