<?php
namespace boru\dweb\Smoke;

class Assert
{
    public static function true($cond, $msg = 'Expected condition to be true')
    {
        if (!$cond) {
            throw new \RuntimeException($msg);
        }
    }

    public static function equals($expected, $actual, $msg = null)
    {
        if ($expected !== $actual) {
            if ($msg === null) {
                $msg = "Expected [" . self::dump($expected) . "] got [" . self::dump($actual) . "]";
            }
            throw new \RuntimeException($msg);
        }
    }

    public static function contains($needle, $haystack, $msg = null)
    {
        $haystack = (string)$haystack;
        $needle = (string)$needle;
        if (strpos($haystack, $needle) === false) {
            if ($msg === null) {
                $msg = "Expected output to contain: " . $needle;
            }
            throw new \RuntimeException($msg);
        }
    }

    // NEW METHODS

    public static function isNull($value, $msg = 'Expected value to be null')
    {
        if ($value !== null) {
            throw new \RuntimeException($msg);
        }
    }

    public static function notNull($value, $msg = 'Expected value to not be null')
    {
        if ($value === null) {
            throw new \RuntimeException($msg);
        }
    }

    public static function notContains($needle, $haystack, $msg = null)
    {
        $haystack = (string)$haystack;
        $needle = (string)$needle;
        if (strpos($haystack, $needle) !== false) {
            if ($msg === null) {
                $msg = "Expected output to not contain: " . $needle;
            }
            throw new \RuntimeException($msg);
        }
    }

    public static function false($cond, $msg = 'Expected condition to be false')
    {
        if ($cond) {
            throw new \RuntimeException($msg);
        }
    }

    public static function notEquals($expected, $actual, $msg = null)
    {
        if ($expected === $actual) {
            if ($msg === null) {
                $msg = "Expected values to be different, both were [" . self::dump($actual) . "]";
            }
            throw new \RuntimeException($msg);
        }
    }

    public static function greaterThan($min, $actual, $msg = null)
    {
        if (!($actual > $min)) {
            if ($msg === null) {
                $msg = "Expected [" . self::dump($actual) . "] to be greater than [" . self::dump($min) . "]";
            }
            throw new \RuntimeException($msg);
        }
    }

    public static function lessThan($max, $actual, $msg = null)
    {
        if (!($actual < $max)) {
            if ($msg === null) {
                $msg = "Expected [" . self::dump($actual) . "] to be less than [" . self::dump($max) . "]";
            }
            throw new \RuntimeException($msg);
        }
    }

    public static function inArray($needle, array $haystack, $msg = null, $strict = true)
    {
        if (!in_array($needle, $haystack, $strict)) {
            if ($msg === null) {
                $msg = "Expected value [" . self::dump($needle) . "] to be in array";
            }
            throw new \RuntimeException($msg);
        }
    }

    public static function notInArray($needle, array $haystack, $msg = null, $strict = true)
    {
        if (in_array($needle, $haystack, $strict)) {
            if ($msg === null) {
                $msg = "Expected value [" . self::dump($needle) . "] to not be in array";
            }
            throw new \RuntimeException($msg);
        }
    }

    private static function dump($v)
    {
        if (is_scalar($v) || $v === null) return var_export($v, true);
        return gettype($v);
    }
}
