<?php
namespace boru\dweb\Smoke;

use boru\dweb\Contracts\SettingsInterface;
use boru\dweb\Kernel\Container;
use boru\dweb\Http\Request;

class SmokeContext
{
    /** @var SettingsInterface */
    public $config;

    /** @var Container */
    public $container;

    /** @var mixed */
    public $routes;

    /** @var callable */
    public $pipeline;

    public function __construct(SettingsInterface $config, Container $container, $routes, $pipeline)
    {
        $this->config = $config;
        $this->container = $container;
        $this->routes = $routes;
        $this->pipeline = $pipeline;
    }

    /**
     * Dispatch a request through the pipeline.
     * @return mixed Response
     */
    public function dispatch(Request $req)
    {
        return call_user_func($this->pipeline, $req);
    }
}
