<?php
namespace boru\dweb\Support;

use boru\dweb\Kernel\ModuleManager;
use boru\dweb\Kernel\Container;

use boru\dweb\Smoke\SmokeSuiteRegistry;
use boru\dweb\Smoke\SmokeSuiteProviderInterface;

use boru\dweb\Cli\CommandRegistry;
use boru\dweb\Cli\CliCommandProviderInterface;

use boru\dweb\Contracts\LayoutProviderInterface;
use boru\dweb\Contracts\LayoutRegistryInterface;

class ModuleExtensions
{
    /** @var ModuleManager */
    private $moduleManager;

    /** @var Container */
    private $container;

    public function __construct(ModuleManager $moduleManager, Container $container)
    {
        $this->moduleManager = $moduleManager;
        $this->container = $container;
    }

    public function registerSuites()
    {
        $registry = $this->container->get(SmokeSuiteRegistry::class);

        foreach ($this->moduleManager->all() as $m) {
            if ($m instanceof SmokeSuiteProviderInterface) {
                $m->suites($registry);
            }
        }
    }

    public function registerCommands()
    {
        $registry = $this->container->get(CommandRegistry::class);

        foreach ($this->moduleManager->all() as $m) {
            if ($m instanceof CliCommandProviderInterface) {
                $m->commands($registry);
            }
        }
    }

    public function registerLayouts()
    {
        // Layout registry may be absent in exotic setups, so be defensive.
        if (!$this->container->has(LayoutRegistryInterface::class)) {
            return;
        }

        $registry = $this->container->get(LayoutRegistryInterface::class);

        foreach ($this->moduleManager->all() as $m) {
            if ($m instanceof LayoutProviderInterface) {
                $m->registerLayouts($registry);
            }
        }
    }
}
