# gitlab

## Description
This is a simple gitlab api client written in PHP.

## Usage Example Code
```php
$url = "https://git.boru.dev/";
$token = "private-access-token";

$gitlab = new boru\gitlab\Gitlab($url,$token);
$response = $gitlab->searchForGroup("borulibs");
$group = $response->object(0);
if($group) {
    $id = $group->get('id');

    //List up to 100 projects in the group
    $projects = $gitlab->listGroupProjects($id,["query"=>["per_page"=>100]]);
    foreach($projects->objects() as $project) {
        echo $project->get('name')."\n";
    }

    //Alternatively, use the Gitlab::iterate() method to get all projects in the group
    $projects = boru\gitlab\Gitlab::iterate($gitlab->listGroupProjects($id,["query"=>["per_page"=>5]]));

    //You can also use a callback on each page of results
    $projects = boru\gitlab\Gitlab::iterate($gitlab->listGroupProjects($id,["query"=>["per_page"=>5]]),function($response) {
        foreach($response->objects() as $project) {
            echo $project->get('name')."\n";
        }
    });
}
```