<?php
namespace boru\gitlab;

use boru\gitlab\core\API;

class Gitlab {
    private $api;
    public function __construct($gitlabUrl="",$personalAccessToken="") {
        $this->api = new API($gitlabUrl,$personalAccessToken);
    }
    public function api() {
        return $this->api;
    }
    public function setUrl($gitlabUrl="") {
        $this->api->gitlabUrl($gitlabUrl);
        return $this;
    }
    public function setToken($personalAccessToken="") {
        $this->api->personalAccessToken($personalAccessToken);
        return $this;
    }

    public function listProjects($options=[]) {
        return $this->api->get("/projects",$options);
    }
    public function getProject($id,$options=[]) {
        return $this->api->get("/projects/".$id,$options);
    }
    public function createProject($options=[]) {
        return $this->api->post("/projects",$options);
    }

    public function listGroups($options=[]) {
        return $this->api->get("/groups",$options);
    }
    public function getGroup($id,$options=[]) {
        return $this->api->get("/groups/".$id,$options);
    }
    public function listGroupProjects($id,$options=[]) {
        return $this->api->get("/groups/".$id."/projects",$options);
    }
    public function searchForGroup($query,$options=[]) {
        return $this->api->get("/groups?search=".urlencode($query),$options);
    }

    public static function iterate($response,$callback=null) {
        $results = [];
        if(!$callback) {
            $callback = function($response) use (&$results) {
                $results = array_merge($results,$response->objects());
            };
        }
        $callback($response);
        while($response = $response->next()) {
            $callback($response);
        }
        return $results;
    }
}