<?php
namespace boru\gitlab\core;

use boru\dhttp\core\Options;
use boru\dhttp\core\Request;
use boru\dhttp\core\Response;

class API {
    private $gitlabUrl;
    private $personalAccessToken;
    public function __construct($gitlabUrl="",$personalAccessToken="") {
        $this->gitlabUrl($gitlabUrl);
        $this->personalAccessToken($personalAccessToken);
    }
    public function gitlabUrl($gitlabUrl="") {
        if($gitlabUrl) {
            if(substr($gitlabUrl, -1) != "/") {
                $gitlabUrl .= "/";
            }
            $this->gitlabUrl = $gitlabUrl;
        }
        return $this->gitlabUrl;
    }
    public function personalAccessToken($personalAccessToken="") {
        if($personalAccessToken) {
            $this->personalAccessToken = $personalAccessToken;
        }
        return $this->personalAccessToken;
    }

    /**
     * Return the full url for the given path, or the base url if no path is given
     * @param string $path 
     * @return string 
     */
    public function url($path="") {
        if(substr($path, 0, 1) == "/") {
            $path = substr($path, 1);
        } elseif (substr($path, 0, 4) == "http") {
            return $path;
        } 
        if(substr($path, 0, 4) != "api/") {
            $path = "api/v4/".$path;
        }

        return $this->gitlabUrl().$path;
    }

    /**
     * Set the options for the request, including the url, method, and adding the private token to the headers
     * @param string $path 
     * @param string $method 
     * @param array $options 
     * @return Options 
     */
    public function setOptions($path="",$method="GET",$options=[]) {
        $options = new Options($options);
        $options->merge([
            "url" => $this->url($path),
            "method" => $method,
            "as"=>"json"
        ]);
        $options->header("PRIVATE-TOKEN",$this->personalAccessToken());
        return $options;
    }

    public function get($path, $options = []) {
        $options = $this->setOptions($path,"GET",$options);
        return $this->sendRequest(new Request($options));
    }
    public function post($path, $options = []) {
        $options = $this->setOptions($path,"POST",$options);
        $request = new Request($options);
    }
    public function put($path, $options = []) {
        $options = $this->setOptions($path,"PUT",$options);
        $request = new Request($options);
    }
    public function delete($path, $options = []) {
        $options = $this->setOptions($path,"DELETE",$options);
        $request = new Request($options);
    }

    /**
     * Send the request and return the response
     * @param Request $request 
     * @return APIResponse 
     */
    public function sendRequest($request) {
        return new APIResponse($request);
    }
}