<?php
namespace boru\gitlab\core;

use boru\dhttp\core\Response;
use boru\dhutils\base\SimpleContainer;
use boru\dhutils\dhGlobal;
use React\Promise\PromiseInterface;

class APIResponse {
    private $response;
    private $request;
    private $success = false;
    private $exception = false;
    private $data = [];
    private $pagination = [];
    private $prev = null;
    private $objects = [];

    
    public function __construct($request,$prev=null) {
        $this->request = $request;
        $this->sendAndParse($request->send());
        $this->prev = $prev;
    }
    /**
     * @param Response|PromiseInterface|Exception $response 
     * @return void 
     */
    private function sendAndParse($response) {
        if($response instanceof Response) {
            $this->parseResponse($response);
        } elseif($response instanceof PromiseInterface) {
            $response->then(function($response) {
                return $this->parseResponse($response);
            });
        } else {
            $this->exception = $response;
            $this->success = false;
            $this->data = [];
        }
    }

    /**
     * 
     * @param Response $response 
     * @return self
     */
    private function parseResponse($response) {
        if($response instanceof Response) {
            $this->response = $response;
            $this->success = $response->code() >= 200 && $response->code() < 300;
            $this->data = $response->asArray();
            $this->pagination = $this->makePaginationLinks($response->headerLine('link'));
        } else {
            $this->response = false;
        }
        return $this;
    }

    private function makePaginationLinks($headerLine=null) {
        if(!$headerLine) {
            return [];
        }
        $links = [];
        $parts = explode(",",$headerLine);
        foreach($parts as $link) {
            $link = trim($link);
            $link = explode(";",$link);
            $link[0] = trim($link[0]," <>");
            $link[1] = trim($link[1]," <>");
            $link[1] = trim($link[1]," rel=");
            $link[1] = trim($link[1],'"');
            $links[$link[1]] = $link[0];
        }
        return $links;
    }

    public function success() {
        return $this->success;
    }
    public function body() {
        return $this->response->asString();
    }
    public function code() {
        return $this->response->code();
    }
    public function headers() {
        return $this->response->headers();
    }
    public function header($key,$default=null) {
        return $this->response->header($key,$default);
    }
    public function pagination() {
        return $this->pagination;
    }
    public function exception() {
        return $this->exception;
    }
    /**
     * @param bool $force (false)
     * @return SimpleContainer[]
     */
    public function objects($force=false) {
        if(empty($this->objects) || $force) {
            $data = $this->get();
            if(is_array($data) && !empty($data) && dhGlobal::array_is_list($data)) {
                foreach($data as $key=>$value) {
                    $this->objects[$key] = new SimpleContainer($value);
                }
            }
        }
        return $this->objects;
    }
    /**
     * 
     * @param string|int $key 
     * @return SimpleContainer|false
     */
    public function object($key) {
        $objects = $this->objects();
        if(isset($objects[$key]) && is_object($objects[$key])) {
            return $objects[$key];
        }
        return false;
    }
    public function get($dotKey=null,$default=null) {
        if(empty($this->data)) {
            return $default;
        }
        if($dotKey) {
            if(strpos($dotKey,".") === false) {
                return isset($this->data[$dotKey]) ? $this->data[$dotKey] : $default;
            }
            return dhGlobal::dotGet($this->data,$dotKey,$default);
        }
        return $this->data;
    }

    public function next() {
        if(isset($this->pagination['next'])) {
            $req = clone $this->request;
            $req->url($this->pagination['next']);
            return new self($req,$this);
        }
        return false;
    }
    public function prev($force=false) {
        if(!$force && $this->prev) {
            return $this->prev;
        }
        if(isset($this->pagination['prev'])) {
            $req = clone $this->request;
            $req->url($this->pagination['prev']);
            return new self($req);
        }
        return false;
    }
    public function first() {
        if(isset($this->pagination['first'])) {
            $req = clone $this->request;
            $req->url($this->pagination['first']);
            return new self($req);
        }
        return false;
    }
    public function last() {
        if(isset($this->pagination['last'])) {
            $req = clone $this->request;
            $req->url($this->pagination['last']);
            return new self($req);
        }
        return false;
    }
}