<?php

namespace boru\ocr\Agent;

use boru\ocr\OcrEngineResult;

class AiOcrOrchestrator
{
    /** @var bool */
    protected $usePlanner = true;

    protected $logger;

    /**
     * @param array $options
     *  - usePlanner (bool) default true
     *  - logger (callable|null) default null
     * @param callable|null $logger
     */
    public function __construct(array $options = array(), callable $logger = null)
    {
        if (array_key_exists('usePlanner', $options)) {
            $this->usePlanner = (bool)$options['usePlanner'];
        }
        if ($logger !== null) {
            $this->logger = $logger;
        } elseif (array_key_exists('logger', $options)) {
            $this->logger = is_callable($options['logger']) ? $options['logger'] : null;
        } else {
            $this->logger = function ($msg) {
                // Default logger implementation (e.g., log to console or file)
                //echo $msg . PHP_EOL;
            };
        }
    }

    /**
     * @param string $pdfPath
     * @param OcrEngineResult $bundle
     * @param array $plannerOptions
     * @param array $finalAgentOptions
     * @return string final framed output
     */
    public function run($pdfPath, OcrEngineResult $bundle, $plannerOptions = null, $finalAgentOptions = null)
    {
        if(!$plannerOptions) {
            $plannerOptions = new AgentOptions();
            $plannerOptions->logger = $this->logger;
        }
        if(!$finalAgentOptions) {
            $finalAgentOptions = new AgentOptions();
            $finalAgentOptions->logger = $this->logger; 
        }
        // Build TSV tools using the correct FunctionBase/ToolDefinition system.
        $bridge = new EvidenceToolBridge($bundle->evidence());
        $tools = $bridge->buildTools();
        $plan = null;
        if ($this->usePlanner) {
            $planner = new PlannerAgent($pdfPath, $plannerOptions, $this->logger);
            $plan = $planner->run($bundle);
        }

        $final = new FinalAgent($pdfPath, $tools, $finalAgentOptions, $this->logger);
        return $final->run($bundle, $plan);
    }
}
