<?php

namespace boru\ocr\Agent;

use boru\ocr\Evidence\TsvEvidenceIndex;
use boru\ocr\Agent\Functions\TsvEvidenceTools;

class EvidenceToolBridge
{
    /** @var TsvEvidenceIndex */
    protected $evidence;

    protected $logger = null;

    public function __construct(TsvEvidenceIndex $evidence, $logger = null)
    {
        $this->evidence = $evidence;
        $this->logger = $logger;
    }

    /**
     * @return \boru\boruai\Models\ToolDefinition[]
     */
    public function buildTools()
    {
        // Set the active evidence index for static tool callbacks
        TsvEvidenceTools::setEvidence($this->evidence);
        TsvEvidenceTools::setLogger($this->logger);

        // Return the tool definitions array
        return TsvEvidenceTools::functionDefinitions();
    }
}
