<?php

namespace boru\ocr\Layout\Support;

/**
 * Lightweight diagnostics container for layout building.
 */
class LayoutDiagnostics
{
    /** @var int */
    public $page = 0;

    /** @var string */
    public $profile = 'document';

    /** @var array */
    public $profileDecision = array();

    /** @var string */
    public $strategy = '';

    /** @var array<string,mixed> */
    public $metrics = array();

    /** @var array<string> */
    public $notes = array();

    public function toArray()
    {
        return array(
            'page' => $this->page,
            'profile' => $this->profile,
            'profileDecision' => $this->profileDecision,
            'strategy' => $this->strategy,
            'metrics' => $this->metrics,
            'notes' => $this->notes,
        );
    }
}
