<?php

namespace boru\ocr\Source\Spreadsheet;

class ExcelCsvConverter
{
    /**
     * Convert a spreadsheet file (xls/xlsx) into a CSV string.
     * All sheets are concatenated with a "### Sheet: {name}" header.
     *
     * @param string $filePath
     * @return string
     * @throws \Exception
     */
    public function convertSpreadsheetToCsvString($filePath)
    {
        if (!class_exists('\\PHPExcel_IOFactory')) {
            require_once 'libraries/PHPExcel/PHPExcel.php';

            if (!class_exists('\\PHPExcel_IOFactory')) {
                throw new \Exception(
                    "PHPExcel library not found. Please ensure it is installed and the include path is correct."
                );
            }
        }

        $inputFileType = \PHPExcel_IOFactory::identify($filePath);
        $reader = \PHPExcel_IOFactory::createReader($inputFileType);

        /** @var \PHPExcel $excel */
        $excel = $reader->load($filePath);

        $csvChunks = array();

        foreach ($excel->getWorksheetIterator() as $sheet) {
            $csvChunks[] = '### Sheet: ' . $sheet->getTitle();

            $highestRow = $sheet->getHighestRow();
            $highestColumnIndex = \PHPExcel_Cell::columnIndexFromString(
                $sheet->getHighestColumn()
            );

            for ($row = 1; $row <= $highestRow; $row++) {
                $rowData = array();

                for ($col = 0; $col < $highestColumnIndex; $col++) {
                    $cell = $sheet->getCellByColumnAndRow($col, $row);
                    $rowData[] = $this->escapeCsvValue($cell->getFormattedValue());
                }

                $csvChunks[] = implode(',', $rowData);
            }

            $csvChunks[] = '';
        }

        return implode("\n", $csvChunks);
    }

    protected function escapeCsvValue($value)
    {
        if ($value === null) {
            return '';
        }

        $value = (string)$value;
        $value = str_replace('"', '""', $value);

        if (
            strpos($value, ',') !== false ||
            strpos($value, '"') !== false ||
            strpos($value, "\n") !== false ||
            strpos($value, "\r") !== false
        ) {
            return '"' . $value . '"';
        }

        return $value;
    }
}
