<?php

namespace boru\ocr\Evidence;

/**
 * Represents an anchor match found on a page.
 */
class TsvTextMatch
{
    /** @var int 1-based */
    public $page;

    /** @var string "block:par:line" */
    public $lineKey;

    /** @var string Full line text where match was found */
    public $text;

    /** @var int */
    public $left;

    /** @var int */
    public $top;

    /** @var int */
    public $width;

    /** @var int */
    public $height;

    /**
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->page = isset($data['page']) ? (int)$data['page'] : 0;
        $this->lineKey = isset($data['lineKey']) ? (string)$data['lineKey'] : '';
        $this->text = isset($data['text']) ? (string)$data['text'] : '';
        $this->left = isset($data['left']) ? (int)$data['left'] : 0;
        $this->top = isset($data['top']) ? (int)$data['top'] : 0;
        $this->width = isset($data['width']) ? (int)$data['width'] : 0;
        $this->height = isset($data['height']) ? (int)$data['height'] : 0;
    }
}
