<?php

namespace boru\ocr\Format;

class FrameFormatter
{
    /**
     * @param array $pages Array of page strings
     * @param string $title
     * @return string
     */
    public static function framePages(array $pages, $title = 'DOCUMENT OCR OUTPUT')
    {
        $out = '';
        $out .= '[BEGIN ' . $title . ']' . "\n";

        $i = 0;
        foreach ($pages as $pageText) {
            $i++;
            $out .= '[BEGIN PAGE ' . $i . ']' . "\n";
            $out .= rtrim((string)$pageText) . "\n";
            $out .= '[END PAGE ' . $i . ']' . "\n";
        }

        $out .= '[END ' . $title . ']' . "\n";
        return $out;
    }
}
