<?php

namespace boru\ocr\Layout\Detector;

/**
 * Result object for table layout detection.
 *
 * PHP 5.6 compatible DTO (public props).
 */
class TableLayoutDecision
{
    /** @var bool */
    public $isTable = false;

    /** @var float */
    public $score = 0.0;

    /** @var array */
    public $features = array();

    public function __construct($isTable = false, $score = 0.0, array $features = array())
    {
        $this->isTable = (bool)$isTable;
        $this->score = (float)$score;
        $this->features = $features;
    }

    public function toArray()
    {
        return array(
            'isTable' => $this->isTable,
            'score' => $this->score,
            'features' => $this->features,
        );
    }
}
