<?php

namespace boru\ocr\Tesseract;

/**
 * Lightweight DTO for common tesseract settings.
 * Keep this small; you can extend over time.
 */
class TesseractOptions
{
    /** @var string|null */
    public $lang = null; // e.g. 'eng'

    /** @var int|null */
    public $psm = null;  // Page segmentation mode

    /** @var int|null */
    public $oem = null;  // OCR engine mode

    /** @var array */
    public $config = array(); // key => value OR raw flags (see buildArgs)

    /** @var int|null */
    public $timeoutSeconds = null; // optional, used if you later swap runner

    /** @var bool */
    public $quiet = true;

    /**
     * @param array $data
     */
    public function __construct(array $data = array())
    {
        if (isset($data['lang'])) $this->lang = $data['lang'];
        if (isset($data['psm']))  $this->psm  = $data['psm'];
        if (isset($data['oem']))  $this->oem  = $data['oem'];
        if (isset($data['config']) && is_array($data['config'])) $this->config = $data['config'];
        if (isset($data['timeoutSeconds'])) $this->timeoutSeconds = $data['timeoutSeconds'];
        if (isset($data['quiet'])) $this->quiet = (bool)$data['quiet'];
    }
}
