<?php
namespace boru\ocr\Agent;

class AgentOptions {
    public $model = "gpt-4.1";
    public $reference = "";
    public $logger;

    public function __construct($optionsArray = []) {
        if(!empty($optionsArray)) {
            $this->setOptions($optionsArray);
        }
    }

    public function model($model=null) {
        if ($model !== null) {
            $this->model = $model;
        }
        return $this->model;
    }

    public function reference($reference=null) {
        if ($reference !== null) {
            $this->reference = $reference;
        }
        return $this->reference;
    }

    public function logger($logger=null) {
        if ($logger !== null) {
            $this->logger = $logger;
        }
        return $this->logger;
    }

    private function setOptions($optionsArray) {
        if(isset($optionsArray['model'])) {
            $this->model = $optionsArray['model'];
        }
        if(isset($optionsArray['reference'])) {
            $this->reference = $optionsArray['reference'];
        }
        if(isset($optionsArray['logger'])) {
            $this->logger = $optionsArray['logger'];
        }
    }

    public function set($option,$value) {
        $option = strtolower($option);
        if($option === "model") {
            $this->model = $value;
        } elseif($option === "reference") {
            $this->reference = $value;
        } elseif($option === "logger") {
            $this->logger = $value;
        } else {
            throw new \InvalidArgumentException("Invalid option: $option");
        }
    }

    public static function fromInput($input) {
        if($input instanceof self) {
            return $input;
        }
        if(is_string($input)) {
            $options = new self(['reference' => $input]);
            return $options;
        }
        $optionsArray = [];
        if (isset($input['model'])) {
            $optionsArray['model'] = $input['model'];
        }
        if (isset($input['reference'])) {
            $optionsArray['reference'] = $input['reference'];
        }
        if (isset($input['logger'])) {
            $optionsArray['logger'] = $input['logger'];
        }
        return new self($optionsArray);
    }
}