<?php

namespace boru\ocr\Confidence;

class Hotspot
{
    /** @var int */
    public $page = 0;

    /** @var string */
    public $lineKey = '';

    /** @var int */
    public $left = 0;
    public $top = 0;
    public $width = 0;
    public $height = 0;

    /** @var float|null */
    public $confAvg = null;

    /** @var int */
    public $tokenCount = 0;

    /** @var float */
    public $lowConfRatio = 0.0;

    /** @var string */
    public $sampleText = '';

    /** @var array<string> */
    public $tags = array();

    public function toArray()
    {
        return array(
            'page' => $this->page,
            'lineKey' => $this->lineKey,
            'bbox' => array(
                'left' => $this->left,
                'top' => $this->top,
                'width' => $this->width,
                'height' => $this->height,
            ),
            'confAvg' => $this->confAvg,
            'tokenCount' => $this->tokenCount,
            'lowConfRatio' => $this->lowConfRatio,
            'sampleText' => $this->sampleText,
            'tags' => $this->tags,
        );
    }
}
