<?php
namespace boru\ocr\Layout;

class LayoutOptions
{
    /** @var callable|null */
    public $logger = null;

    // ---- Common options ----
    public $minConf = 0;
    public $dropEmpty = true;
    public $diagnostics = true;
    public $autoDetectTableProfile = true;
    public $layoutProfile = 'auto';

    // ---- Rendering options ----
    public $preserveGapSpacing = false;
    public $gapExtraSpacePx = 12;

    // ---- document ordering ----
    public $bandTolerancePx = 14;
    public $headerBandPx = 300;
    public $multiColumn = true;
    public $detectMixedLayout = true;
    public $breakY = 0;

    // ---- table options ----
    public $tableMinScoreToTrigger = 0.62;
    public $tableMinWordCount = 60;
    public $tableMinLineCount = 12;
    public $tableMinColumnAlignmentScore = 0.45;
    public $tableMinNumericRatio = 0.22;

    // ---- table regions ----
    public $detectTableRegions = true;
    public $tableRegionMarkers = true;
    public $tableRegionBucketPx = 18;
    public $tableRegionWindow = 7;
    public $tableRegionMinLines = 5;
    public $tableRegionScoreThreshold = 0.55;
    public $tableRegionMinTokens = 60;
    public $tableRegionMinCols = 3;
    

    // ---- key-value tables ----
    public $detectKeyValueTables = true;
    public $keyValueScoreThreshold = 0.45;
    public $keyValueMinLines = 4;
    public $keyValueMinTokens = 10; //24
    public $keyValueMaxValuesPerLine = 1;
    public $keyValueValueRegex = '/^[\$\(\)]?\s*[-+]?\d[\d,]*(\.\d+)?\s*$/';
    public $keyValueRequireNumericValue = true;
    public $keyValueValueAlignTolerancePx = 14;


    // ---- diagram ----
    public $diagramScoreThreshold = 0.62;
    public $shortTokenLen = 4;
    public $clusterPadPx = 70;
    public $minRegionWords = 8;
    public $diagramKeyValueScoreBias = 0.0;
    public $diagramTableScoreBias = 0.0;    

    // ---- layout options ----
    public $tablePxPerSpace = 10;
    public $tableMinSpaces = 1;
    public $tableMaxSpaces = 24;
    public $tableSmallGapPx = 6;
    public $tableTrimToken = true;

    // ---- Support options ----
    public $fallbackTopClusterPx = 0;

    /**
     * 
     * @param array|self $opts 
     * @return LayoutOptions 
     */
    public static function create($opts=null)
    {
        if ($opts instanceof self) {
            return $opts;
        }
        $o = new self();
        if (!is_array($opts)) {
            return $o;
        }
        foreach ($opts as $k => $v) {
            if (property_exists($o, $k)) {
                $o->$k = $v;
            }
        }
        return $o;
    }

    /**
     * Helper: adjusted threshold for diagram context
     */
    public function keyValueThresholdForProfile($profile)
    {
        if ($profile === 'diagram') {
            return $this->keyValueScoreThreshold + $this->diagramKeyValueScoreBias;
        }
        return $this->keyValueScoreThreshold;
    }

    public function tableThresholdForProfile($profile)
    {
        if ($profile === 'diagram') {
            return $this->tableRegionScoreThreshold + $this->diagramTableScoreBias;
        }
        return $this->tableRegionScoreThreshold;
    }
}
