<?php

namespace boru\ocr\Layout\Support;

use boru\ocr\Tesseract\Tsv\TsvRow;

class BoundsCalculator
{
    /**
     * @param TsvRow[] $line
     * @return array|null
     */
    public function lineBounds(array $line)
    {
        if (empty($line)) return null;

        $minLeft = null;
        $maxRight = null;
        $minTop = null;
        $maxBottom = null;

        foreach ($line as $r) {
            $l = (int)$r->left;
            $t = (int)$r->top;
            $rgt = (int)$r->right();
            $bot = $t + (int)$r->height;

            if ($minLeft === null || $l < $minLeft) $minLeft = $l;
            if ($maxRight === null || $rgt > $maxRight) $maxRight = $rgt;

            if ($minTop === null || $t < $minTop) $minTop = $t;
            if ($maxBottom === null || $bot > $maxBottom) $maxBottom = $bot;
        }

        if ($minLeft === null || $maxRight === null || $minTop === null || $maxBottom === null) return null;

        return array(
            'minLeft' => $minLeft,
            'maxRight' => $maxRight,
            'minTop' => $minTop,
            'maxBottom' => $maxBottom,
            'midX' => (int)floor(($minLeft + $maxRight) / 2),
        );
    }

    /**
     * @param TsvRow[] $rows
     * @return array|null
     */
    public function pageBoundsFromRows(array $rows)
    {
        $minLeft = null;
        $maxRight = null;
        $minTop = null;
        $maxBottom = null;

        foreach ($rows as $r) {
            if(is_array($r)) $r = new TsvRow($r);
            if ((int)$r->level !== 5) continue;
            if ($r->text === '') continue;

            $l = (int)$r->left;
            $t = (int)$r->top;
            $rgt = (int)$r->right();
            $bot = $t + (int)$r->height;

            if ($minLeft === null || $l < $minLeft) $minLeft = $l;
            if ($maxRight === null || $rgt > $maxRight) $maxRight = $rgt;

            if ($minTop === null || $t < $minTop) $minTop = $t;
            if ($maxBottom === null || $bot > $maxBottom) $maxBottom = $bot;
        }

        if ($minLeft === null || $maxRight === null || $minTop === null || $maxBottom === null) return null;

        return array(
            'minLeft' => $minLeft,
            'maxRight' => $maxRight,
            'minTop' => $minTop,
            'maxBottom' => $maxBottom,
        );
    }
}
