<?php

namespace boru\ocr\Layout\Strategy;

use boru\ocr\Layout\Support\LayoutDiagnostics;

/**
 * Produces ordered lines for a page.
 */
interface ReadingOrderStrategyInterface
{
    /**
     * @param array<int,array> $lines array of lines, each line is array of TsvRow
     * @param LayoutDiagnostics|null $diag
     * @return array<int,array>
     */
    public function order(array $lines, LayoutDiagnostics $diag = null);
}
