<?php

namespace boru\ocr\Page;

/**
 * Represents a spreadsheet as a text-only, single-page document.
 */
class ExcelPageTextProvider
{
    /** @var string */
    protected $csvPath;

    public function __construct($csvPath)
    {
        if (!file_exists($csvPath)) {
            throw new \Exception("CSV not found: " . $csvPath);
        }
        $this->csvPath = $csvPath;
    }

    /**
     * @return array<int,string>
     */
    public function getTextPages()
    {
        $text = file_get_contents($this->csvPath);
        return array(0 => $text);
    }
}
