<?php
namespace boru\ocr\Page;

interface PageImageProviderInterface
{
    /**
     * Render PDF pages to PNG files (optionally tiled).
     *
     * Return array indexed by page (0-based):
     *  - string: single full-page PNG path
     *  - array:  tiles, each: ['path' => string, 'offset_x' => int, 'offset_y' => int]
     *
     * @return array<int, string|array<int,array{path:string,offset_x:int,offset_y:int}>>
     */
    public function getPages();

    /**
     * Cleanup any temporary files created by this provider.
     * Safe to call multiple times.
     *
     * @return void
     */
    public function cleanup();
}
