<?php
namespace boru\ocr\Cli;

use boru\ocr\OCRLogger;

class CliCommon {
    public static function ensureTempDir(string $subDir): string {
        $tmpDir = sys_get_temp_dir() . '/' . $subDir;
        if (!is_dir($tmpDir)) {
            mkdir($tmpDir, 0777, true);
        }
        return $tmpDir;
    }
    public static function ensureOutputDir(?string $outputDir): string {
        if ($outputDir === null) {
            $outputDir = getcwd() . '/ocr_output';
        }
        if (!is_dir($outputDir)) {
            mkdir($outputDir, 0777, true);
        }
        return $outputDir;
    }

    public static function getLogger($show_log = true, $show_info=true, $show_debug=false, $show_error=true) {
        $logger = new OCRLogger();
        if ($show_log) {
            $logger->enableLevel(OCRLogger::$LEVEL_LOG);
        }
        if ($show_info) {
            $logger->enableLevel(OCRLogger::$LEVEL_INFO);
        }
        if ($show_debug) {
            $logger->enableLevel(OCRLogger::$LEVEL_DEBUG);
        }
        if ($show_error) {
            $logger->enableLevel(OCRLogger::$LEVEL_ERROR);
        }
        return $logger;
    }
}