<?php

namespace boru\ocr\Layout\Detector;

/**
 * Small DTO describing chosen layout profile and the evidence used.
 */
class LayoutProfileDecision
{
    /** @var string auto|document|diagram */
    public $profile = 'document';

    /** @var float 0..1 */
    public $confidence = 0.0;

    /** @var float Threshold used to decide diagram vs document */
    public $threshold = 0.0;

    /** @var float Diagram score computed from features */
    public $diagramScore = 0.0;

    /** @var array<string,mixed> */
    public $features = array();

    /** @var array<string> */
    public $notes = array();

    public function toArray()
    {
        return array(
            'profile' => $this->profile,
            'confidence' => $this->confidence,
            'threshold' => $this->threshold,
            'diagramScore' => $this->diagramScore,
            'features' => $this->features,
            'notes' => $this->notes,
        );
    }
}
