<?php

namespace boru\ocr\Layout\Support;

class RegionLineSelector
{
    /** @var BoundsCalculator */
    protected $bounds;

    /** @var int */
    protected $pad;

    public function __construct(BoundsCalculator $bounds, $pad = 10)
    {
        $this->bounds = $bounds;
        $this->pad = (int)$pad;
    }

    /**
     * @param array<int, array> $lines array<int, TsvRow[]>
     * @param array $region
     * @return array<int, array> subset of $lines that intersect region
     */
    public function linesInRegion(array $lines, array $region)
    {
        $out = array();
        $pad = $this->pad;

        foreach ($lines as $ln) {
            $b = $this->bounds->lineBounds($ln);
            if (!$b) continue;

            $xOverlap = ($b['minLeft'] <= $region['maxRight'] + $pad) && ($b['maxRight'] >= $region['minLeft'] - $pad);
            $yOverlap = ($b['minTop'] <= $region['maxBottom'] + $pad) && ($b['maxBottom'] >= $region['minTop'] - $pad);

            if ($xOverlap && $yOverlap) $out[] = $ln;
        }

        return $out;
    }
}
