<?php
namespace boru\ocr\Traits;

use boru\ocr\OCRLogger;

trait OcrLogTrait
{
    /** @var OCRLogger|null */
    protected $logger = null;

    protected function getLoggerName()
    {
        $className =  get_class($this);
        $parts = explode('\\', $className);
        return end($parts);
    }
    public function logInfo($message)
    {
        if ($this->logger !== null) {
            $this->logger->output($this->getLoggerName(),OCRLogger::$LEVEL_INFO, $message);
        } else {
            echo "[INFO] ".$this->getLoggerName().": " . $message . PHP_EOL;
        }
    }
    public function logError($message)
    {
        if ($this->logger !== null) {
            $this->logger->output($this->getLoggerName(),OCRLogger::$LEVEL_ERROR, $message);
        } else {
            echo "[ERROR] ".$this->getLoggerName().": " . $message . PHP_EOL;
        }
    }
    public function logDebug($message)
    {
        if ($this->logger !== null) {
            $this->logger->output($this->getLoggerName(),OCRLogger::$LEVEL_DEBUG, $message);
        } else {
            echo "[DEBUG] ".$this->getLoggerName().": " . $message . PHP_EOL;
        }
    }
    public function logLog($message)
    {
        if ($this->logger !== null) {
            $this->logger->output($this->getLoggerName(),OCRLogger::$LEVEL_LOG, $message);
        } else {
            echo "[LOG] ".$this->getLoggerName().": " . $message . PHP_EOL;
        }
    }
}