<?php

namespace boru\ocr\Layout\Support;

class RegionSignature
{
    /** @var LineRenderer */
    protected $renderer;

    /** @var int */
    protected $maxLen;

    public function __construct(LineRenderer $renderer, $maxLen = 8000)
    {
        $this->renderer = $renderer;
        $this->maxLen = (int)$maxLen;
    }

    /**
     * Build a normalized signature string for region line text.
     *
     * @param array<int, array> $regionLines array<int, TsvRow[]>
     * @return string
     */
    public function signatureFromLines(array $regionLines)
    {
        $buf = array();

        foreach ($regionLines as $ln) {
            $t = trim($this->renderer->renderLine($ln));
            if ($t === '') continue;

            $t = preg_replace('/\s+/u', ' ', $t);
            $t = mb_strtolower($t);

            if (mb_strlen($t) <= 1) continue;

            $buf[] = $t;
        }

        if (empty($buf)) return '';

        $sig = implode("\n", $buf);
        if (strlen($sig) > $this->maxLen) {
            $sig = substr($sig, 0, $this->maxLen);
        }

        return $sig;
    }
}
