<?php
namespace boru\ocr\Cli;


use boru\cli2\CLI;
use boru\cli2\CLIContext;
use boru\cli2\Commands\HelpCommand;
use boru\cli2\Params\Flag;
use boru\cli2\Params\Option;

class OcrCLI {
    private static $isInit = false;
    protected static $cli;
    public function __construct() {
        static::init();
    }

    public static function init($force=false) {
        if(self::$isInit && !$force) {
            return static::$cli;
        }
        self::$isInit = true;
        $cli = CLI::create('OcrCLI|Ocr CLI Interface for debugging/testing OCR engine features');
        $cli->params([
            Option::create("c|config|path to config.json (boruAI) file"),
        ]);
        $cli->onHandle(function(CLIContext $ctx) {
            $configPath = $ctx->get('config');
            if($configPath && file_exists($configPath)) {
                \boru\boruai\BoruAI::init($configPath);
            }
            $ctx->set('boruai_is_init', true);
        });

        static::$cli = $cli;

        // register commands
        static::registerCommands();

        return static::$cli;
    }

    private static function registerCommands() {
        // Register command groups
        static::$cli->register(new HelpCommand());
        static::$cli->register(new DebugCommand());
        static::$cli->register(new TesseractCommand());
        //static::$cli->register(new TestCommand());
    }
}